(defun C:CENMARK()
   (setq nlay (getvar "clayer"))
   (COMMAND "OSNAP" "NEAR")
   (setq pt (getpoint "\nSelect object or point: "))
   (COMMAND "OSNAP" "NONE")
   (setq sp (ssget pt))
   (if (null sp) (setq cp pt)
     (setq cp (osnap pt "cen"))
   )
   (setq th (getdist pt (strcat "\nLength of Cen-mark<" (rtos (getvar "dimcen")) ">: ")))
   (if (= th nil)
       (setq th (getvar "dimcen")))
   (command "layer" "s" "center" "")
   (command "line" (polar cp pi (/ th 2))
                   (polar cp 0 (/ th 2)) "")
   (command "array" "l" "" "c" cp "90" "2" "y")
   (command "layer" "s" nlay "")
)
